/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm;

import app.rovas.josm.gui.CreateRovasReportDialog;
import app.rovas.josm.gui.RovasConnectorDialog;
import app.rovas.josm.model.AnyOsmDataChangeTracker;
import app.rovas.josm.model.RovasPreference;
import app.rovas.josm.model.RovasProperties;
import app.rovas.josm.model.TimeTrackingManager;
import java.util.Optional;
import javax.swing.Icon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class RovasPlugin
extends Plugin {
    public static final ImageProvider LOGO = new ImageProvider("rovas_logo");
    private final PreferenceSetting preference = new RovasPreference();
    private final TimeTrackingManager timeTrackingManager = new TimeTrackingManager();

    public RovasPlugin(PluginInformation info) {
        super(info);
        MainApplication.getLayerManager().addAndFireLayerChangeListener((LayerManager.LayerChangeListener)new AnyOsmDataChangeTracker(this.timeTrackingManager));
        this.timeTrackingManager.trackChangeNow();
        OsmServerWriter.registerPostprocessor((uploadedPrimitives, progressMonitor) -> new Thread(() -> {
            if (RovasProperties.UNPAID_EDITOR.get().booleanValue()) {
                long changesetId;
                Optional<Changeset> changeset = Optional.empty();
                if (uploadedPrimitives != null && !uploadedPrimitives.isEmpty() && (changesetId = (long)((OsmPrimitive)uploadedPrimitives.iterator().next()).getChangesetId()) > 0L) {
                    Changeset cs = new Changeset((int)changesetId);
                    changeset = Optional.of(cs);
                }
                int totalObjects = uploadedPrimitives != null ? uploadedPrimitives.size() : 0;
                long totalSeconds = this.timeTrackingManager.commit();
                int minutes = totalObjects > 0 ? (int)Math.round((double)totalSeconds / 60.0) : 0;
                new CreateRovasReportDialog(this.timeTrackingManager, changeset, totalSeconds);
            } else {
                new Notification(I18n.tr((String)"A Rovas work report can not be created, as your work is paid by a company. The setting can be changed in the Rovas Connector plugin preferences.", (Object[])new Object[0])).setIcon((Icon)ImageProvider.get((String)"info")).show();
                this.timeTrackingManager.setCurrentlyTrackedSeconds(0L);
            }
        }).start());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (newFrame != null && newFrame.getToggleDialog(RovasConnectorDialog.class) == null) {
            newFrame.addToggleDialog((ToggleDialog)new RovasConnectorDialog(this.timeTrackingManager));
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return this.preference;
    }
}

