/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.action;

import app.rovas.josm.model.TimeTrackingManager;
import app.rovas.josm.util.GuiComponentFactory;
import app.rovas.josm.util.I18nStrings;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;

public class ResetTimerAction
extends JosmAction {
    private static final String TRANSLATABLE_LABEL = I18n.marktr((String)"Reset timer");
    private final TimeTrackingManager timeTrackingManager;

    public ResetTimerAction(TimeTrackingManager timeTrackingManager) {
        super(I18n.tr((String)TRANSLATABLE_LABEL, (Object[])new Object[0]), "preferences/reset", I18n.tr((String)"Reset the timer (either to 0 or an arbitrary value)", (Object[])new Object[0]), null, false);
        this.timeTrackingManager = timeTrackingManager;
    }

    public void actionPerformed(ActionEvent e) {
        ResetPanel resetPanel = new ResetPanel();
        if (JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), resetPanel, I18n.tr((String)TRANSLATABLE_LABEL, (Object[])new Object[0]), 2, -1) == 0) {
            this.timeTrackingManager.setCurrentlyTrackedSeconds((long)resetPanel.getMinutes() * 60L);
        }
    }

    private static final class ResetPanel
    extends JPanel {
        private final SpinnerNumberModel hourModel = new SpinnerNumberModel(0, 0, 0x2222221, 1);
        private final SpinnerNumberModel minuteModel = new SpinnerNumberModel(0, 0, 59, 1);

        private ResetPanel() {
            super(new FlowLayout(1));
            this.add(GuiComponentFactory.createLabel(I18n.tr((String)"Reset the timer to", (Object[])new Object[0]), false));
            this.add(GuiComponentFactory.createSpinner(this.hourModel, 3, true));
            this.add(GuiComponentFactory.createLabel(I18nStrings.trShorthandForHours(), false));
            this.add(GuiComponentFactory.createSpinner(this.minuteModel, 3, true));
            this.add(GuiComponentFactory.createLabel(I18nStrings.trShorthandForMinutes(), false));
        }

        private int getMinutes() {
            return this.hourModel.getNumber().intValue() * 60 + this.minuteModel.getNumber().intValue();
        }
    }
}

