/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.api;

import app.rovas.josm.api.ApiException;
import app.rovas.josm.api.ApiQuery;
import app.rovas.josm.model.ApiCredentials;
import app.rovas.josm.util.TimeConverterUtil;
import app.rovas.josm.util.UrlProvider;
import jakarta.json.Json;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Optional;
import org.openstreetmap.josm.tools.I18n;

public final class ApiCreateAur
extends ApiQuery<ApiQuery.ErrorCode> {
    private final int workReportId;
    private final int reportedMinutes;

    public ApiCreateAur(UrlProvider urlProvider, int workReportId, int reportedMinutes) {
        super(urlProvider, urlProvider.rulesCreateAUR());
        this.workReportId = workReportId;
        this.reportedMinutes = reportedMinutes;
    }

    protected ApiQuery.ErrorCode[] getKnownErrorCodes() {
        return new ApiQuery.ErrorCode[0];
    }

    @Override
    protected ApiQuery.ErrorCode createAdditionalErrorCode(Optional<Integer> code, String translatableMessage) {
        return new ApiQuery.ErrorCode(code, translatableMessage);
    }

    @Override
    protected int query(ApiCredentials credentials) throws ApiException {
        URLConnection connection = this.sendPostRequest(credentials, Json.createObjectBuilder().add("project_id", 35259).add("wr_id", this.workReportId).add("usage_fee", TimeConverterUtil.minutesToChrons(this.reportedMinutes) * 0.03).add("note", I18n.tr((String)"{0}% fee levied by the ''JOSM Rovas connector'' project for using the plugin", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", 3.0)})));
        return ApiCreateAur.decodeJsonResult(connection, "result");
    }
}

