/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.api;

import app.rovas.josm.api.ApiException;
import app.rovas.josm.api.ApiQuery;
import app.rovas.josm.gen.BuildInfo;
import app.rovas.josm.model.ApiCredentials;
import app.rovas.josm.util.UrlProvider;
import com.drew.lang.annotations.NotNull;
import jakarta.json.Json;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;

public final class ApiCreateWorkReport
extends ApiQuery<ErrorCode> {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final double minutes;
    private final Optional<Changeset> changeset;

    public ApiCreateWorkReport(UrlProvider urlProvider, int minutes, @NotNull Optional<Changeset> changeset) {
        super(urlProvider, urlProvider.rulesCreateWorkReport());
        this.minutes = minutes;
        this.changeset = changeset;
    }

    protected ErrorCode[] getKnownErrorCodes() {
        return new ErrorCode[]{new ErrorCode(Optional.of(0), I18n.marktr((String)"The report is unpublished and no verifiers were invited!"), ErrorCode.ContinueOption.CONTINUE_TO_AUR_QUERY), new ErrorCode(Optional.of(-1), I18n.marktr((String)"You are not a shareholder in the project with ID set in the preferences!"), ErrorCode.ContinueOption.SHOW_WORK_REPORT_DIALOG_AGAIN), new ErrorCode(Optional.of(-2), I18n.marktr((String)"The report you are trying to create has the `date_started` earlier than the date when you registered for Rovas!"), ErrorCode.ContinueOption.SHOW_WORK_REPORT_DIALOG_AGAIN), new ErrorCode(Optional.of(-3), I18n.marktr((String)"A work report was created, but no verifiers were invited as you have outstanding reports to verify. Please login to Rovas and verify the reports!"), ErrorCode.ContinueOption.CONTINUE_TO_AUR_QUERY)};
    }

    @Override
    protected ErrorCode createAdditionalErrorCode(Optional<Integer> code, String translatableMessage) {
        return new ErrorCode(code, translatableMessage, ErrorCode.ContinueOption.SHOW_WORK_REPORT_DIALOG_AGAIN);
    }

    @Override
    protected int query(ApiCredentials credentials) throws ApiException {
        byte[] accessToken = new byte[12];
        RANDOM.nextBytes(accessToken);
        URLConnection connection = this.sendPostRequest(credentials, Json.createObjectBuilder().add("wr_classification", 1645).add("wr_description", I18n.tr((String)"Made edits to the OpenStreetMap project. This report was created automatically by the {0}", (Object[])new Object[]{UrlProvider.toHtmlHyperlink(BuildInfo.OSM_WIKI_URL, I18n.tr((String)"Rovas connector plugin for JOSM", (Object[])new Object[0]))})).add("wr_activity_name", I18n.tr((String)"Creating map data with JOSM", (Object[])new Object[0])).add("wr_hours", this.minutes / 60.0).add("wr_web_address", this.changeset.map(Changeset::getId).map(it -> String.format("https://overpass-api.de/achavi/?changeset=%d", it)).orElse("")).add("parent_project_nid", credentials.getProjectId()).add("date_started", this.changeset.map(Changeset::getCreatedAt).map(Instant::getEpochSecond).orElse(Instant.now().getEpochSecond()).longValue()).add("access_token", Base64.getEncoder().encodeToString(accessToken)).add("publish_status", 1));
        return ApiCreateWorkReport.decodeJsonResult(connection, "created_wr_nid");
    }

    public static class ErrorCode
    extends ApiQuery.ErrorCode {
        @NotNull
        private final ContinueOption continueOption;

        public ErrorCode(@NotNull Optional<Integer> code, @NotNull String translatableMessage, @NotNull ContinueOption continueOption) {
            super(code, translatableMessage);
            this.continueOption = Objects.requireNonNull(continueOption);
        }

        @NotNull
        public ContinueOption getContinueOption() {
            return this.continueOption;
        }

        @Override
        public String toString() {
            return super.toString() + " (continue with " + this.continueOption.name() + ")";
        }

        public static enum ContinueOption {
            SHOW_WORK_REPORT_DIALOG_AGAIN,
            CONTINUE_TO_AUR_QUERY;

        }
    }
}

