/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.api;

import java.net.URL;
import org.openstreetmap.josm.tools.I18n;

public abstract class ApiException
extends Exception {
    private final URL url;
    private final String translatableMessage;
    private final boolean shouldBeReportedAsBug;

    protected ApiException(URL url, String translatableMessage, boolean shouldBeReportedAsBug, Throwable cause) {
        super(cause);
        this.url = url;
        this.translatableMessage = translatableMessage;
        this.shouldBeReportedAsBug = shouldBeReportedAsBug;
    }

    @Override
    public String getMessage() {
        return this.translatableMessage;
    }

    @Override
    public String getLocalizedMessage() {
        return I18n.tr((String)this.translatableMessage, (Object[])new Object[0]);
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isShouldBeReportedAsBug() {
        return this.shouldBeReportedAsBug;
    }

    public static class WrongPluginApiCredentials
    extends ApiException {
        public WrongPluginApiCredentials(URL url) {
            super(url, I18n.marktr((String)"A work report could not be created, because the API key and/or token set in the preferences are incorrect, or your Rovas access was restricted. Please log into Rovas to verify your credentials and status."), false, null);
        }
    }

    public static class DecodeResponse
    extends ApiException {
        public DecodeResponse(URL url, Throwable cause) {
            super(url, I18n.marktr((String)"There was an error decoding the server response!"), true, cause);
        }
    }

    public static class ConnectionFailure
    extends ApiException {
        public ConnectionFailure(URL url, Throwable cause) {
            super(url, I18n.marktr((String)"There was a connection issue!"), false, cause);
        }
    }
}

