/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.api;

import app.rovas.josm.api.ApiException;
import app.rovas.josm.model.ApiCredentials;
import app.rovas.josm.util.UrlProvider;
import com.drew.lang.annotations.NotNull;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportQueue;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public abstract class ApiQuery<EC extends ErrorCode> {
    private static final Pattern POSITIVE_INT_PATTERN = Pattern.compile("^-?[0-9]+$");
    protected final UrlProvider urlProvider;
    protected final URL queryUrl;

    public ApiQuery(UrlProvider urlProvider, URL queryUrl) {
        this.urlProvider = urlProvider;
        this.queryUrl = queryUrl;
    }

    protected abstract EC[] getKnownErrorCodes();

    protected abstract EC createAdditionalErrorCode(Optional<Integer> var1, String var2);

    protected abstract int query(ApiCredentials var1) throws ApiException;

    public void query(ApiCredentials credentials, Consumer<Integer> successCallback, Consumer<EC> errorCallback) {
        block6: {
            try {
                int result = this.query(credentials);
                Optional<ErrorCode> errorCode = Stream.of(this.getKnownErrorCodes()).filter(it -> it.getCode().map(code -> code == result).orElse(false)).findFirst();
                if (errorCode.isPresent()) {
                    errorCallback.accept(errorCode.get());
                } else {
                    Optional<Integer> success = Optional.of(result).filter(it -> it > 0);
                    if (success.isPresent()) {
                        Logging.debug((String)"[rovas] API query successful ({0})", (Object[])new Object[]{success.get()});
                        successCallback.accept(success.get());
                    } else {
                        errorCallback.accept(this.createAdditionalErrorCode(Optional.of(result), I18n.marktr((String)"An unknown error occurred!")));
                    }
                }
            }
            catch (ApiException e) {
                errorCallback.accept(this.createAdditionalErrorCode(Optional.empty(), e.getMessage()));
                if (!e.isShouldBeReportedAsBug()) break block6;
                BugReportQueue.getInstance().submit(new ReportedException((Throwable)e));
            }
        }
    }

    protected URLConnection sendPostRequest(ApiCredentials credentials, JsonObjectBuilder requestContent) throws ApiException.ConnectionFailure {
        URLConnection connection;
        try {
            connection = this.queryUrl.openConnection();
        }
        catch (IOException e) {
            throw new ApiException.ConnectionFailure(this.queryUrl, (Throwable)e);
        }
        try {
            connection.setRequestProperty("API-KEY", credentials.getApiKey());
            connection.setRequestProperty("TOKEN", credentials.getApiToken());
            connection.setRequestProperty("Content-Type", "application/json;charset=" + StandardCharsets.UTF_8.name());
            connection.setRequestProperty("User-Agent", "JOSM-rovas/0.1.4-SNAPSHOT");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setChunkedStreamingMode(0);
                ((HttpURLConnection)connection).setRequestMethod("POST");
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
                String request = requestContent.build().toString();
                Logging.debug((String)"[rovas] API request:\n{0}", (Object[])new Object[]{request});
                writer.write(request);
            }
        }
        catch (IOException e) {
            ApiQuery.disconnect(connection);
            throw new ApiException.ConnectionFailure(this.queryUrl, (Throwable)e);
        }
        return connection;
    }

    /*
     * Exception decompiling
     */
    protected static int decodeJsonResult(URLConnection connection, String key) throws ApiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<Integer> decodeJsonResult(JsonObject json, String key) {
        JsonValue value = (JsonValue)json.get((Object)key);
        Optional<Integer> result = value instanceof JsonString ? Optional.of((JsonString)value).map(JsonString::getString).filter(string -> POSITIVE_INT_PATTERN.matcher((CharSequence)string).matches()).map(Integer::parseInt) : (value instanceof JsonNumber ? Optional.of((JsonNumber)value).map(JsonNumber::intValue) : Optional.empty());
        return result;
    }

    private static void disconnect(URLConnection connection) {
        Utils.instanceOfAndCast((Object)connection, HttpURLConnection.class).ifPresent(HttpURLConnection::disconnect);
    }

    private static /* synthetic */ ApiException.DecodeResponse lambda$decodeJsonResult$4(ByteArrayOutputStream capture, URLConnection connection) {
        Logging.warn((String)MessageFormat.format("Can''t decode this ({0} bytes):\n{1}", capture.toByteArray().length, new String(capture.toByteArray(), StandardCharsets.UTF_8)));
        return new ApiException.DecodeResponse(connection.getURL(), null);
    }

    private static /* synthetic */ Optional lambda$decodeJsonResult$3(String key, JsonObject it) {
        return ApiQuery.decodeJsonResult(it, key);
    }

    public static class ErrorCode {
        @NotNull
        private final Optional<Integer> code;
        @NotNull
        private final String translatableMessage;

        public ErrorCode(@NotNull Optional<Integer> code, @NotNull String translatableMessage) {
            this.code = Objects.requireNonNull(code);
            this.translatableMessage = Objects.requireNonNull(translatableMessage);
        }

        @NotNull
        public Optional<Integer> getCode() {
            return this.code;
        }

        @NotNull
        public String getTranslatableMessage() {
            return this.translatableMessage;
        }

        public String toString() {
            return "ErrorCode " + this.code.map(String::valueOf).orElse("\u2039null\u203a") + " (message: \"" + I18n.tr((String)this.translatableMessage, (Object[])new Object[0]) + "\")";
        }
    }
}

