/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.gui;

import app.rovas.josm.gui.NonBlankTextFieldValidator;
import app.rovas.josm.model.ApiCredentials;
import app.rovas.josm.model.RovasProperties;
import app.rovas.josm.util.GBCUtil;
import app.rovas.josm.util.GuiComponentFactory;
import app.rovas.josm.util.UrlProvider;
import com.drew.lang.annotations.Nullable;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class ApiCredentialsPanel
extends VerticallyScrollablePanel {
    protected static final GBC GBC_COLUMN_A = GBCUtil.fixedToColumn(0, GBC.std().insets(5).span(1).anchor(22));
    protected static final GBC GBC_COLUMNS_ABCD = GBCUtil.fixedToColumn(0, GBC.std().insets(5).span(4).fill(2).anchor(10));
    protected static final GBC GBC_COLUMNS_BC = GBCUtil.fixedToColumn(1, GBC.std().insets(5).span(2).fill(2).anchor(21));
    protected static final GBC GBC_COLUMN_B = GBCUtil.fixedToColumn(1, GBC.std().insets(5).span(1).fill(2).weight(0.0, 0.0).anchor(21));
    protected static final GBC GBC_COLUMN_D = GBCUtil.fixedToColumn(3, GBC.std().insets(5).span(1).fill(2).anchor(21));
    protected static final GBC GBC_COLUMNS_CD = GBCUtil.fixedToColumn(2, GBC.std().insets(5).span(2).fill(2).anchor(21));
    protected static final GBC GBC_COLUMNS_BCD = GBCUtil.fixedToColumn(1, GBC.std().insets(5).span(3).fill(2).anchor(21));
    private final JLabel apiKeyLabel = new JLabel(I18n.tr((String)"API key", (Object[])new Object[0]));
    private final JTextField apiKeyField = new JPasswordField(35);
    private final JLabel apiTokenLabel = new JLabel(I18n.tr((String)"API token", (Object[])new Object[0]));
    private final JTextField apiTokenField = new JPasswordField(35);
    private final JEditorPane seeProfilePageNote = GuiComponentFactory.createHyperlinkedMultilineLabel("<html>" + I18n.tr((String)"Values for these fields can be found on your {0}.", (Object[])new Object[]{UrlProvider.toHtmlHyperlink(UrlProvider.getInstance().userProfile(), I18n.tr((String)"Rovas profile page", (Object[])new Object[0]))}) + "</html>");
    private final JLabel activeProjectIdLabel = new JLabel(I18n.tr((String)"Project ID", (Object[])new Object[0]));
    private final SpinnerNumberModel activeProjectIdSpinnerModel = new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 0);
    private final JSpinner activeProjectIdSpinner = GuiComponentFactory.createSpinner(this.activeProjectIdSpinnerModel, 5, true);
    private final JButton activeProjectOpenButton = new JButton(I18n.tr((String)"Open project page in Rovas", (Object[])new Object[0]), ImageProvider.get((String)"help", (String)"internet", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SIDEBUTTON));
    private final JTextComponent activeProjectIdDescription = new JMultilineLabel(I18n.tr((String)"(the parent project of the created work reports)", (Object[])new Object[0]));
    private final JEditorPane validationWarning = new JMultilineLabel("<html><div style='background:#fdc14b;padding:5px 10px'>" + I18n.tr((String)"All fields have to be filled out!", (Object[])new Object[0]) + "</div></html>");

    public ApiCredentialsPanel(boolean showValidationWarning) {
        this.validationWarning.setVisible(false);
        if (showValidationWarning) {
            NonBlankTextFieldValidator apiKeyValidator = new NonBlankTextFieldValidator(this.apiKeyField);
            NonBlankTextFieldValidator apiTokenValidator = new NonBlankTextFieldValidator(this.apiTokenField);
            AbstractTextComponentValidator projectIdValidator = new AbstractTextComponentValidator(((JSpinner.DefaultEditor)this.activeProjectIdSpinner.getEditor()).getTextField()){

                public void validate() {
                    if (this.isValid()) {
                        this.feedbackValid("");
                    } else {
                        this.feedbackInvalid(I18n.tr((String)"The project ID must be \u2265 {0}!", (Object[])new Object[]{2}));
                    }
                }

                public boolean isValid() {
                    return ApiCredentials.isValidProjectId(ApiCredentialsPanel.this.activeProjectIdSpinnerModel.getNumber().intValue());
                }
            };
            List<AbstractTextComponentValidator> validators = Arrays.asList(new AbstractTextComponentValidator[]{apiKeyValidator, apiTokenValidator, projectIdValidator});
            validators.forEach(validator -> {
                validator.addChangeListener(__ -> {
                    this.validationWarning.setVisible(!validators.stream().allMatch(AbstractTextComponentValidator::isValid));
                    Optional.ofNullable((Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)this))).ifPresent(Window::pack);
                });
                validator.validate();
            });
            this.activeProjectIdSpinnerModel.addChangeListener(ce -> projectIdValidator.validate());
            this.apiKeyField.getDocument().addDocumentListener((DocumentListener)((Object)apiKeyValidator));
            this.apiTokenField.getDocument().addDocumentListener((DocumentListener)((Object)apiTokenValidator));
        }
        this.activeProjectIdSpinnerModel.addChangeListener(changeEvent -> this.activeProjectOpenButton.setEnabled(ApiCredentials.isValidProjectId(this.activeProjectIdSpinnerModel.getNumber().intValue())));
        this.activeProjectOpenButton.setEnabled(false);
        this.activeProjectOpenButton.addActionListener(e -> {
            Optional<Integer> projectId = Optional.ofNullable(this.activeProjectIdSpinnerModel.getNumber()).map(Number::intValue).filter(ApiCredentials::isValidProjectId);
            if (projectId.isPresent()) {
                OpenBrowser.displayUrl((String)UrlProvider.getInstance().node(projectId.get()).toString());
            } else {
                this.activeProjectOpenButton.setEnabled(false);
                Arrays.stream(this.activeProjectIdSpinnerModel.getChangeListeners()).forEach(it -> it.stateChanged(new ChangeEvent(this.activeProjectOpenButton)));
            }
        });
        this.buildGui();
        this.setApiKeyValue(RovasProperties.ROVAS_API_KEY.get());
        this.setApiTokenValue(RovasProperties.ROVAS_API_TOKEN.get());
        this.setActiveProjectIdValue(RovasProperties.ACTIVE_PROJECT_ID.get());
    }

    private void buildGui() {
        this.setLayout(new GridBagLayout());
        this.add(this.validationWarning, GBC_COLUMNS_ABCD);
        this.add(this.apiKeyLabel, GBC_COLUMN_A);
        this.add(this.apiKeyField, GBC_COLUMNS_BC);
        this.add(Box.createHorizontalGlue(), GBC_COLUMN_D);
        this.add(this.apiTokenLabel, GBC_COLUMN_A);
        this.add(this.apiTokenField, GBC_COLUMNS_BC);
        this.add(Box.createHorizontalGlue(), GBC_COLUMN_D);
        this.add(Box.createHorizontalGlue(), GBC_COLUMN_A);
        this.add(GuiComponentFactory.createWrapperPanel(this.seeProfilePageNote), GBC_COLUMNS_BCD);
        this.add(this.activeProjectIdLabel, GBC_COLUMN_A);
        this.add(this.activeProjectIdSpinner, GBC_COLUMN_B);
        this.add(this.activeProjectIdDescription, GBC_COLUMNS_CD);
        this.add(Box.createHorizontalGlue(), GBC_COLUMN_A);
        this.add(GuiComponentFactory.createWrapperPanel(new FlowLayout(0, 0, 0), this.activeProjectOpenButton), GBC_COLUMNS_BC);
        this.add(Box.createHorizontalGlue(), GBC_COLUMN_D);
    }

    public int getActiveProjectIdValue() {
        return Optional.of(this.activeProjectIdSpinnerModel.getNumber().intValue()).filter(ApiCredentials::isValidProjectId).orElse(-1);
    }

    public final void setActiveProjectIdValue(@Nullable Integer projectId) {
        this.activeProjectIdSpinnerModel.setValue(Utils.clamp((int)Optional.ofNullable(projectId).orElse(-1), (int)-1, (int)Integer.MAX_VALUE));
    }

    private String getStringFieldValue(Supplier<JTextField> fieldSupplier) {
        return Optional.of(fieldSupplier.get()).map(JTextComponent::getText).map(String::trim).filter(it -> !it.isEmpty()).orElse(null);
    }

    private void setStringFieldValue(Supplier<JTextField> fieldSupplier, String newValue) {
        fieldSupplier.get().setText(Optional.ofNullable(newValue).map(String::trim).orElse(null));
    }

    public final String getApiKeyValue() {
        return this.getStringFieldValue(() -> this.apiKeyField);
    }

    public final void setApiKeyValue(String apiKey) {
        this.setStringFieldValue(() -> this.apiKeyField, apiKey);
    }

    public final String getApiTokenValue() {
        return this.getStringFieldValue(() -> this.apiTokenField);
    }

    public final void setApiTokenValue(String apiToken) {
        this.setStringFieldValue(() -> this.apiTokenField, apiToken);
    }
}

