/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.gui;

import app.rovas.josm.RovasPlugin;
import app.rovas.josm.gui.upload.UploadStep1AddShareholder;
import app.rovas.josm.model.TimeTrackingManager;
import app.rovas.josm.util.GuiComponentFactory;
import app.rovas.josm.util.I18nStrings;
import app.rovas.josm.util.TimeConverterUtil;
import app.rovas.josm.util.UrlProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class CreateRovasReportDialog
extends JDialog {
    private static final GBC GBC_START_ALIGNED = GBC.eol().anchor(21).fill(2);
    private final SpinnerNumberModel hoursModel;
    private final SpinnerNumberModel minutesModel;
    private final JMultilineLabel calculatedChronLabel = new JMultilineLabel("");
    private final JButton submitReportButton = new JButton(new AbstractAction(I18n.tr((String)"Submit report", (Object[])new Object[0]), ImageProvider.get((String)"upload", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SIDEBUTTON)){

        @Override
        public void actionPerformed(ActionEvent e) {
            new UploadStep1AddShareholder(CreateRovasReportDialog.this.hoursModel.getNumber().intValue() * 60 + CreateRovasReportDialog.this.minutesModel.getNumber().intValue(), CreateRovasReportDialog.this.changeset).showStep(Optional.of(CreateRovasReportDialog.this), UrlProvider.getInstance(), CreateRovasReportDialog.this.timeTrackingManager);
        }
    });
    private final transient Optional<Changeset> changeset;
    private final TimeTrackingManager timeTrackingManager;

    public CreateRovasReportDialog(TimeTrackingManager timeTrackingManager, Optional<Changeset> changeset, long defaultReportedSeconds) {
        super((Frame)MainApplication.getMainFrame(), I18n.tr((String)"Create work report", (Object[])new Object[0]), true);
        int defaultReportedMinutes = Math.min(Integer.MAX_VALUE, TimeConverterUtil.secondsToMinutes(defaultReportedSeconds));
        this.timeTrackingManager = timeTrackingManager;
        this.changeset = changeset;
        this.hoursModel = new SpinnerNumberModel(Utils.clamp((int)(defaultReportedMinutes / 60), (int)0, (int)0x2222221), 0, 0x2222221, 1);
        this.minutesModel = new SpinnerNumberModel(defaultReportedMinutes % 60, 0, 59, 1);
        this.onTimeChange();
        this.hoursModel.addChangeListener(__ -> this.onTimeChange());
        this.minutesModel.addChangeListener(__ -> this.onTimeChange());
        this.setContentPane(this.buildGui());
        this.setMaximumSize(new Dimension(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width / 2, GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private JComponent buildGui() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel heading = new JLabel(I18n.tr((String)"Creating a work report in Rovas", (Object[])new Object[0]));
        heading.setFont(heading.getFont().deriveFont(1, (float)heading.getFont().getSize() * 1.8f));
        heading.setIcon(RovasPlugin.LOGO.setSize(heading.getFont().getSize(), heading.getFont().getSize()).get());
        panel.add((Component)heading, GBC_START_ALIGNED.insets(10, 10, 10, 5));
        panel.add((Component)GuiComponentFactory.createLabel(I18n.tr((String)"Reported labor time", (Object[])new Object[0]), false, 0), GBC_START_ALIGNED.insets(10, 5, 10, 0));
        panel.add((Component)GuiComponentFactory.createWrapperPanel(new FlowLayout(1), GuiComponentFactory.createSpinner(this.hoursModel, 5, true), GuiComponentFactory.createLabel(I18nStrings.trShorthandForHours(), false), GuiComponentFactory.createSpinner(this.minutesModel, 2, true, "00"), GuiComponentFactory.createLabel(I18nStrings.trShorthandForMinutes(), false)), GBC_START_ALIGNED.insets(10, 5, 10, 5));
        panel.add((Component)this.calculatedChronLabel, GBC_START_ALIGNED.insets(10, 5, 10, 5));
        panel.add((Component)GuiComponentFactory.createHyperlinkedMultilineLabel(I18nStrings.trVerificationWarningWithHyperlink()), GBC_START_ALIGNED.insets(10, 5, 10, 5));
        panel.add((Component)GuiComponentFactory.createWrapperPanel(new FlowLayout(1, 10, 10), this.submitReportButton, new JButton(new AbstractAction(I18n.tr((String)"Cancel", (Object[])new Object[0]), ImageProvider.get((String)"cancel", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SIDEBUTTON)){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateRovasReportDialog.this.dispose();
                if (CreateRovasReportDialog.this.changeset.isPresent()) {
                    CreateRovasReportDialog.this.timeTrackingManager.setCurrentlyTrackedSeconds(0L);
                }
            }
        })), GBC_START_ALIGNED.insets(10));
        return panel;
    }

    private void onTimeChange() {
        GuiHelper.runInEDT(() -> {
            int minutes = 60 * this.hoursModel.getNumber().intValue() + this.minutesModel.getNumber().intValue();
            this.calculatedChronLabel.setText(I18n.tr((String)"After approving the time by two Rovas-selected users, you will earn {0,number,#.##} chrons", (Object[])new Object[]{TimeConverterUtil.minutesToChrons(minutes)}));
            this.submitReportButton.setEnabled(minutes > 0);
        });
    }
}

