/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.gui;

import app.rovas.josm.RovasPlugin;
import app.rovas.josm.action.ResetTimerAction;
import app.rovas.josm.gui.TimeTrackingUpdateListener;
import app.rovas.josm.model.RovasPreference;
import app.rovas.josm.model.RovasProperties;
import app.rovas.josm.model.TimeTrackingManager;
import app.rovas.josm.util.GBCUtil;
import app.rovas.josm.util.GuiComponentFactory;
import app.rovas.josm.util.I18nStrings;
import app.rovas.josm.util.TimeConverterUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.MultiLineFlowLayout;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RovasConnectorDialog
extends ToggleDialog
implements TimeTrackingUpdateListener {
    private static final GBC GBC_LEFT_COLUMN = GBCUtil.fixedToColumn(0, GBC.std().insets(5).span(1)).anchor(22);
    private static final GBC GBC_RIGHT_COLUMN = GBCUtil.fixedToColumn(1, GBC.eol().insets(5).span(1).fill(2));
    private static final GBC GBC_BOTH_COLUMNS = GBCUtil.fixedToColumn(0, GBC.eol().insets(5).span(2).fill(2));
    private final JLabel timerValue = new JLabel();
    private final JMultilineLabel previousTimeLabel = new JMultilineLabel("");
    private final JPanel previousTimePanel = new JPanel(new BorderLayout());
    private final TimeTrackingManager timeTrackingManager;

    public RovasConnectorDialog(TimeTrackingManager timeTrackingManager) {
        super(I18n.tr((String)"Rovas", (Object[])new Object[0]), "rovas_logo", I18n.tr((String)"Time tracking with Rovas", (Object[])new Object[0]), null, 150, true, RovasPreference.class, false);
        this.timeTrackingManager = timeTrackingManager;
        VerticallyScrollablePanel panel = new VerticallyScrollablePanel((LayoutManager)new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr((String)"Active time", (Object[])new Object[0])), (Object)GBC_LEFT_COLUMN);
        panel.add((Component)this.timerValue, (Object)GBC_RIGHT_COLUMN);
        this.updatePreviousTime();
        this.previousTimePanel.add((Component)this.previousTimeLabel, "Center");
        this.previousTimePanel.setBackground(new Color(0xFFCC33));
        this.previousTimePanel.add((Component)GuiComponentFactory.createWrapperPanel((LayoutManager)new MultiLineFlowLayout(), new JButton(new HandlePreviouslyTrackedTimeAction(true, I18n.tr((String)"Add", (Object[])new Object[0]))), new JButton(new HandlePreviouslyTrackedTimeAction(false, I18n.tr((String)"Discard", (Object[])new Object[0])))), "South");
        panel.add((Component)this.previousTimePanel, (Object)GBC_BOTH_COLUMNS);
        this.createLayout(panel.getVerticalScrollPane(), false, Collections.singletonList(new SideButton((Action)((Object)new ResetTimerAction(timeTrackingManager)))));
        timeTrackingManager.addAndFireTimeTrackingUpdateListener(this);
    }

    private void updatePreviousTime() {
        int previousMinutes = TimeConverterUtil.secondsToMinutes(this.timeTrackingManager.getPreviouslyTrackedSeconds());
        String commonMessage = I18n.tr((String)"You have tracked {0} of active time in a previous JOSM session, which was not reported to Rovas.", (Object[])new Object[]{String.format("<strong>%d\u202f%s %d\u202f%s</strong>", previousMinutes / 60, I18nStrings.trShorthandForHours(), previousMinutes % 60, I18nStrings.trShorthandForMinutes())});
        if (previousMinutes > 0) {
            new Notification(commonMessage + "<br>" + I18n.tr((String)"If you want to add that time to your current timer, you can do that in the Rovas dialog.", (Object[])new Object[0])).setDuration(Notification.TIME_LONG).setIcon((Icon)RovasPlugin.LOGO.setSize(ImageProvider.ImageSizes.DEFAULT).get()).show();
        }
        this.previousTimePanel.setVisible(previousMinutes > 0);
        this.previousTimeLabel.setText(commonMessage + "<br>" + I18n.tr((String)"Should this time be added to the currently tracked active time, or should the previous time be discarded?", (Object[])new Object[0]));
    }

    public void destroy() {
        super.destroy();
        this.timeTrackingManager.removeTimeTrackingUpdateListener(this);
        RovasProperties.ALREADY_TRACKED_TIME.put(Long.valueOf(this.timeTrackingManager.commit()));
    }

    @Override
    public void updateNumberOfTrackedSeconds(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Number of tracked seconds must always be non-negative (was" + n + ")!");
        }
        long minutes = TimeConverterUtil.secondsToMinutes(n);
        GuiHelper.runInEDT(() -> this.timerValue.setText(String.format("<html><strong style='font-size:1.8em'>%d</strong>&#8239;" + I18nStrings.trShorthandForHours() + "&nbsp;<strong style='font-size:1.8em'>%02d</strong>&#8239;" + I18nStrings.trShorthandForMinutes() + "</html>", minutes / 60L, minutes % 60L)));
    }

    private final class HandlePreviouslyTrackedTimeAction
    extends AbstractAction {
        private final boolean shouldBeAdded;

        private HandlePreviouslyTrackedTimeAction(boolean shouldBeAdded, String name) {
            super(name);
            this.shouldBeAdded = shouldBeAdded;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RovasConnectorDialog.this.timeTrackingManager.handlePreviouslyTrackedSeconds(this.shouldBeAdded);
            RovasConnectorDialog.this.previousTimePanel.setVisible(false);
        }
    }
}

