/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.gui;

import app.rovas.josm.gui.ApiCredentialsPanel;
import app.rovas.josm.model.RovasProperties;
import app.rovas.josm.util.GuiComponentFactory;
import app.rovas.josm.util.UrlProvider;
import java.awt.Component;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class RovasPreferencePanel
extends ApiCredentialsPanel {
    private final JEditorPane feeNote = GuiComponentFactory.createHyperlinkedMultilineLabel("<html>" + I18n.tr((String)"To reward the authors of this {1}, a fee equal to {0}% of the amount you earn from reports created by the plugin will be levied on those earnings.", (Object[])new Object[]{String.format("%.2f", 3.0), UrlProvider.toHtmlHyperlink(UrlProvider.getInstance().node(35259), I18n.tr((String)"Rovas connector plugin", (Object[])new Object[0]).replace(" ", "&nbsp;"))}) + "</html>");
    private final JLabel inactivityToleranceLabel = new JLabel(I18n.tr((String)"Timer tolerance", (Object[])new Object[0]));
    private final SpinnerNumberModel inactivityToleranceModel = new SpinnerNumberModel(Utils.clamp((int)RovasProperties.INACTIVITY_TOLERANCE.get(), (int)1, (int)240), 1, 240, 1);
    private final JSpinner inactivityToleranceValue = GuiComponentFactory.createSpinner(this.inactivityToleranceModel, 5, true);
    private final JTextComponent inactivityToleranceDescription = new JMultilineLabel(I18n.tr((String)"the lag in seconds after last edit to be counted as active time", (Object[])new Object[0]), false);
    private final JCheckBox unpaidEditorCheckbox = new JCheckBox("<html>" + I18n.tr((String)"I am not paid for JOSM work by a company (you will only be prompted to send a work report, if you confirm this)", (Object[])new Object[0]) + "</html>");

    public RovasPreferencePanel() {
        super(false);
        this.extendGui();
        ExpertToggleAction.addVisibilitySwitcher((Component)this.inactivityToleranceLabel);
        ExpertToggleAction.addVisibilitySwitcher((Component)this.inactivityToleranceValue);
        ExpertToggleAction.addVisibilitySwitcher((Component)this.inactivityToleranceDescription);
    }

    private void extendGui() {
        this.add(new JPanel(), GBC_COLUMN_A);
        this.add(GuiComponentFactory.createWrapperPanel(this.feeNote), GBC_COLUMNS_BCD);
        this.add(this.inactivityToleranceLabel, GBC_COLUMN_A);
        this.add(this.inactivityToleranceValue, GBC_COLUMN_B);
        this.add(this.inactivityToleranceDescription, GBC_COLUMNS_CD);
        this.add(new JPanel(), GBC_COLUMN_A);
        this.add(this.unpaidEditorCheckbox, GBC_COLUMNS_BCD);
        this.add(Box.createVerticalGlue(), GBC_COLUMN_A.fill(3));
    }

    public int getInactivityTolerance() {
        return this.inactivityToleranceModel.getNumber().intValue();
    }

    public void setInactivityTolerance(Integer value) {
        this.inactivityToleranceModel.setValue(Utils.clamp((int)Optional.ofNullable(value).orElse(30), (int)1, (int)240));
    }

    public boolean isUnpaidEditor() {
        return this.unpaidEditorCheckbox.isSelected();
    }

    public void setUnpaidEditor(boolean isUnpaidEditor) {
        this.unpaidEditorCheckbox.setSelected(isUnpaidEditor);
    }
}

