/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.gui.upload;

import app.rovas.josm.api.ApiCheckOrAddShareholder;
import app.rovas.josm.gui.ApiCredentialsPanel;
import app.rovas.josm.gui.upload.UploadStep;
import app.rovas.josm.gui.upload.UploadStep2CreateWorkReport;
import app.rovas.josm.model.ApiCredentials;
import app.rovas.josm.model.RovasProperties;
import app.rovas.josm.model.TimeTrackingManager;
import app.rovas.josm.util.UrlProvider;
import com.drew.lang.annotations.NotNull;
import java.awt.Component;
import java.awt.Window;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;

public class UploadStep1AddShareholder
implements UploadStep {
    protected static final int MAX_STEP_REPETITIONS = 5;
    private final int minutes;
    private final Optional<Changeset> changeset;

    public UploadStep1AddShareholder(int minutes, @NotNull Optional<Changeset> changeset) {
        this.minutes = minutes;
        this.changeset = Objects.requireNonNull(changeset);
    }

    @Override
    public void showStep(@NotNull Optional<Window> parent, @NotNull UrlProvider urlProvider, @NotNull TimeTrackingManager timeTrackingManager) {
        parent.ifPresent(it -> it.setVisible(false));
        this.showStep(parent, urlProvider, timeTrackingManager, false, 0);
    }

    private void showStep(@NotNull Optional<Window> parent, UrlProvider urlProvider, TimeTrackingManager timeTrackingManager, boolean forceCredentialsDialog, int recursionDepth) {
        ApiCredentials credentials;
        Optional<ApiCredentials> initialCredentials = ApiCredentials.createFrom(RovasProperties.ROVAS_API_KEY.get(), RovasProperties.ROVAS_API_TOKEN.get(), RovasProperties.ACTIVE_PROJECT_ID.get());
        if (!initialCredentials.isPresent() || forceCredentialsDialog) {
            ApiCredentialsPanel apiCredentialsPanel = new ApiCredentialsPanel(true);
            Optional<Object> newApiCredentials = Optional.empty();
            while (!newApiCredentials.isPresent()) {
                if (0 == JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), (Object)apiCredentialsPanel, I18n.tr((String)"Enter API credentials", (Object[])new Object[0]), 2, -1)) {
                    newApiCredentials = ApiCredentials.createFrom(apiCredentialsPanel.getApiKeyValue(), apiCredentialsPanel.getApiTokenValue(), apiCredentialsPanel.getActiveProjectIdValue());
                    continue;
                }
                parent.ifPresent(it -> it.setVisible(true));
                return;
            }
            RovasProperties.persistApiCredentials(apiCredentialsPanel);
            credentials = (ApiCredentials)newApiCredentials.get();
        } else {
            credentials = initialCredentials.get();
        }
        new ApiCheckOrAddShareholder(urlProvider).query(credentials, meritId -> new UploadStep2CreateWorkReport(credentials, this.minutes, this.changeset).showStep(parent, urlProvider, timeTrackingManager), errorCode -> {
            if (recursionDepth < 5 && 0 == JOptionPane.showConfirmDialog(parent.orElse(null), "<html>" + I18n.tr((String)errorCode.getTranslatableMessage(), (Object[])new Object[0]) + errorCode.getCode().map(code -> " " + I18n.tr((String)"(error {0})", (Object[])new Object[]{code})).orElse("") + "<br>" + I18n.tr((String)"Do you want to modify the API credentials and then retry?", (Object[])new Object[0]) + "</html>", I18n.tr((String)"Error. Retry?", (Object[])new Object[0]), 0, 2)) {
                this.showStep(parent, urlProvider, timeTrackingManager, true, recursionDepth + 1);
            } else {
                parent.ifPresent(it -> it.setVisible(true));
            }
        });
    }
}

