/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.gui.upload;

import app.rovas.josm.api.ApiCreateWorkReport;
import app.rovas.josm.api.ApiQuery;
import app.rovas.josm.gui.upload.UploadStep;
import app.rovas.josm.gui.upload.UploadStep3CreateAur;
import app.rovas.josm.model.ApiCredentials;
import app.rovas.josm.model.TimeTrackingManager;
import app.rovas.josm.util.UrlProvider;
import com.drew.lang.annotations.NotNull;
import java.awt.Window;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;

public class UploadStep2CreateWorkReport
implements UploadStep {
    private final ApiCredentials credentials;
    private final int minutes;
    private final Optional<Changeset> changeset;

    public UploadStep2CreateWorkReport(ApiCredentials credentials, int minutes, Optional<Changeset> changeset) {
        this.credentials = Objects.requireNonNull(credentials);
        this.minutes = minutes;
        this.changeset = Objects.requireNonNull(changeset);
    }

    @Override
    public void showStep(@NotNull Optional<Window> parent, @NotNull UrlProvider urlProvider, @NotNull TimeTrackingManager timeTrackingManager) {
        parent.ifPresent(it -> it.setVisible(false));
        new ApiCreateWorkReport(urlProvider, this.minutes, this.changeset).query(this.credentials, workReportId -> new UploadStep3CreateAur(this.credentials, (int)workReportId, this.minutes).showStep(parent, urlProvider, timeTrackingManager), errorCode -> {
            this.showErrorMessage(parent, (ApiQuery.ErrorCode)errorCode);
            if (errorCode.getContinueOption() == ApiCreateWorkReport.ErrorCode.ContinueOption.CONTINUE_TO_AUR_QUERY) {
                new UploadStep3CreateAur(this.credentials, 0, this.minutes).showStep(parent, urlProvider, timeTrackingManager);
            } else {
                parent.ifPresent(it -> it.setVisible(true));
            }
        });
    }

    private void showErrorMessage(Optional<Window> parent, ApiQuery.ErrorCode errorCode) {
        JOptionPane.showMessageDialog(parent.orElse(null), I18n.tr((String)"An error occured!: {0}{1}", (Object[])new Object[]{errorCode.getCode().map(it -> it + " ").orElse(""), I18n.tr((String)errorCode.getTranslatableMessage(), (Object[])new Object[0])}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
    }
}

