/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.gui.upload;

import app.rovas.josm.api.ApiCreateAur;
import app.rovas.josm.gui.upload.UploadStep;
import app.rovas.josm.model.ApiCredentials;
import app.rovas.josm.model.TimeTrackingManager;
import app.rovas.josm.util.UrlProvider;
import com.drew.lang.annotations.NotNull;
import java.awt.Component;
import java.awt.Window;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UploadStep3CreateAur
implements UploadStep {
    private final ApiCredentials credentials;
    private final int workReportId;
    private final int reportedMinutes;

    public UploadStep3CreateAur(ApiCredentials credentials, int workReportId, int reportedMinutes) {
        this.credentials = credentials;
        this.workReportId = workReportId;
        this.reportedMinutes = reportedMinutes;
    }

    @Override
    public void showStep(@NotNull Optional<Window> parent, @NotNull UrlProvider urlProvider, @NotNull TimeTrackingManager timeTrackingManager) {
        timeTrackingManager.setCurrentlyTrackedSeconds(0L);
        parent.ifPresent(Window::dispose);
        new ApiCreateAur(urlProvider, this.workReportId, this.reportedMinutes).query(this.credentials, result -> {
            HtmlPanel panel = new HtmlPanel(I18n.tr((String)"Your {0} was created successfully!", (Object[])new Object[]{UrlProvider.toHtmlHyperlink(UrlProvider.getInstance().node(this.workReportId), I18n.tr((String)"work report", (Object[])new Object[0]))}));
            panel.setOpaque(false);
            panel.enableClickableHyperlinks();
            new Notification().setContent((Component)panel).setIcon((Icon)ImageProvider.get((String)"misc", (String)"check_large")).setDuration(Notification.TIME_LONG).show();
        }, errorCode -> JOptionPane.showMessageDialog(parent.orElse(null), I18n.tr((String)"Failed to create AUR!", (Object[])new Object[0])));
    }
}

