/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.model;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class ApiCredentials {
    public static final int MIN_PROJECT_ID = 2;
    private final String apiKey;
    private final String apiToken;
    private final int projectId;

    public static Optional<ApiCredentials> createFrom(@Nullable String apiKey, @Nullable String apiToken, @Nullable Integer projectId) {
        return Optional.ofNullable(apiKey).flatMap(key -> Optional.ofNullable(apiToken).flatMap(token -> Optional.ofNullable(projectId).filter(ApiCredentials::isValidProjectId).map(id -> new ApiCredentials((String)key, (String)token, (int)id))));
    }

    public static boolean isValidProjectId(Integer value) {
        return value >= 2;
    }

    public ApiCredentials(@NotNull String apiKey, @NotNull String apiToken, int projectId) {
        CheckParameterUtil.ensureThat((boolean)ApiCredentials.isValidProjectId(projectId), () -> "Invalid Project ID (was " + projectId + ")!");
        this.apiKey = Objects.requireNonNull(apiKey);
        this.apiToken = Objects.requireNonNull(apiToken);
        this.projectId = projectId;
    }

    @NotNull
    public String getApiKey() {
        return this.apiKey;
    }

    @NotNull
    public String getApiToken() {
        return this.apiToken;
    }

    public int getProjectId() {
        return this.projectId;
    }
}

