/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.model;

import app.rovas.josm.gui.ApiCredentialsPanel;
import app.rovas.josm.util.NullableProperty;
import com.drew.lang.annotations.NotNull;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.LongProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;

public final class RovasProperties {
    public static final NullableProperty<String> ROVAS_API_KEY = new NullableProperty<String>((AbstractToStringProperty<String>)new StringProperty("rovas.api-key", null), it -> !it.trim().isEmpty());
    public static final NullableProperty<String> ROVAS_API_TOKEN = new NullableProperty<String>((AbstractToStringProperty<String>)new StringProperty("rovas.api-token", null), it -> !it.trim().isEmpty());
    public static final int ACTIVE_PROJECT_ID_NO_VALUE = -1;
    public static final IntegerProperty ACTIVE_PROJECT_ID = new IntegerProperty("rovas.active-project-id", 1998);
    public static final int INACTIVITY_TOLERANCE_MIN_VALUE = 1;
    public static final int INACTIVITY_TOLERANCE_DEFAULT_VALUE = 30;
    public static final int INACTIVITY_TOLERANCE_MAX_VALUE = 240;
    public static final IntegerProperty INACTIVITY_TOLERANCE = new IntegerProperty("rovas.inactivity-tolerance-seconds", 30);
    public static final LongProperty ALREADY_TRACKED_TIME = new LongProperty("rovas.already-tracked-time", 0L);
    public static final BooleanProperty DEVELOPER = new BooleanProperty("rovas.developer", false);
    public static final BooleanProperty UNPAID_EDITOR = new BooleanProperty("rovas.is-unpaid-editor", true);

    private RovasProperties() {
    }

    public static void persistApiCredentials(@NotNull ApiCredentialsPanel apiCredentialsPanel) {
        ROVAS_API_KEY.put(apiCredentialsPanel.getApiKeyValue());
        ROVAS_API_TOKEN.put(apiCredentialsPanel.getApiTokenValue());
        ACTIVE_PROJECT_ID.put(Integer.valueOf(apiCredentialsPanel.getActiveProjectIdValue()));
    }
}

