/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.model;

import app.rovas.josm.gui.TimeTrackingUpdateListener;
import app.rovas.josm.model.RovasProperties;
import app.rovas.josm.util.TimeConverterUtil;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;

public final class TimeTrackingManager {
    static final String LOG_MESSAGE_BACKWARDS_CLOCK = "Your clock seems to have been running backwards!";
    private final ListenerList<TimeTrackingUpdateListener> listeners = ListenerList.create();
    private final long previouslyTrackedSeconds = TimeConverterUtil.clampToSeconds(RovasProperties.ALREADY_TRACKED_TIME.get());
    private final AtomicBoolean previouslyTrackedTimeIsAlreadyAdded = new AtomicBoolean(false);
    private long committedSeconds;
    private Long firstUncommittedChangeTimestamp;
    private Long lastUncommittedChangeTimestamp;

    public void addAndFireTimeTrackingUpdateListener(TimeTrackingUpdateListener listener) {
        this.listeners.addListener((Object)listener);
        this.fireTimeTrackingUpdateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePreviouslyTrackedSeconds(boolean shouldBeAdded) {
        TimeTrackingManager timeTrackingManager = this;
        synchronized (timeTrackingManager) {
            if (!this.previouslyTrackedTimeIsAlreadyAdded.get()) {
                this.previouslyTrackedTimeIsAlreadyAdded.set(true);
                RovasProperties.ALREADY_TRACKED_TIME.put(Long.valueOf(0L));
                if (shouldBeAdded) {
                    this.committedSeconds += Math.min(this.previouslyTrackedSeconds, 128849018369L - this.committedSeconds);
                    this.fireTimeTrackingUpdateListeners();
                }
            }
        }
    }

    private void fireTimeTrackingUpdateListeners() {
        this.listeners.fireEvent(it -> it.updateNumberOfTrackedSeconds(this.committedSeconds + Optional.ofNullable(this.firstUncommittedChangeTimestamp).flatMap(first -> Optional.ofNullable(this.lastUncommittedChangeTimestamp).map(last -> last - first)).orElse(0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPreviouslyTrackedSeconds() {
        TimeTrackingManager timeTrackingManager = this;
        synchronized (timeTrackingManager) {
            return this.previouslyTrackedTimeIsAlreadyAdded.get() || TimeConverterUtil.secondsToMinutes(this.previouslyTrackedSeconds) <= 0 ? 0L : this.previouslyTrackedSeconds;
        }
    }

    public void removeTimeTrackingUpdateListener(TimeTrackingUpdateListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void trackChangeNow() {
        this.trackChangeAt(Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackChangeAt(Instant instant) {
        TimeTrackingManager timeTrackingManager = this;
        synchronized (timeTrackingManager) {
            int tolerance = Math.max(0, RovasProperties.INACTIVITY_TOLERANCE.get());
            Long firstTimestamp = this.firstUncommittedChangeTimestamp;
            Long lastTimestamp = this.lastUncommittedChangeTimestamp;
            long currentTimestamp = instant.getEpochSecond();
            Logging.debug((String)"[TTM] {0,number,#} seconds committed, {1,number,#} - {2,number,#} uncommitted, new change at {3,number,#}", (Object[])new Object[]{this.committedSeconds, firstTimestamp, lastTimestamp, currentTimestamp});
            if (firstTimestamp == null) {
                this.resetAutomaticTracker(currentTimestamp, Optional.empty());
            } else if (lastTimestamp != null) {
                if (currentTimestamp < lastTimestamp) {
                    Logging.error((String)LOG_MESSAGE_BACKWARDS_CLOCK);
                }
                if (currentTimestamp > lastTimestamp + (long)tolerance || currentTimestamp < firstTimestamp) {
                    this.resetAutomaticTracker(currentTimestamp, Optional.of(instant));
                } else {
                    this.lastUncommittedChangeTimestamp = Math.max(lastTimestamp, currentTimestamp);
                    this.fireTimeTrackingUpdateListeners();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentlyTrackedSeconds(long numSeconds) {
        TimeTrackingManager timeTrackingManager = this;
        synchronized (timeTrackingManager) {
            this.resetAutomaticTracker(null, Optional.empty());
            this.committedSeconds = TimeConverterUtil.clampToSeconds(numSeconds);
            this.fireTimeTrackingUpdateListeners();
        }
    }

    public long commit() {
        return this.commit(Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long commit(Instant instant) {
        TimeTrackingManager timeTrackingManager = this;
        synchronized (timeTrackingManager) {
            return this.resetAutomaticTracker(null, Optional.of(instant));
        }
    }

    private long resetAutomaticTracker(Long newValue, Optional<Instant> commitTimeUntil) {
        commitTimeUntil.ifPresent(currentInstant -> {
            Long firstUncommitted = this.firstUncommittedChangeTimestamp;
            Long lastUncommitted = this.lastUncommittedChangeTimestamp;
            if (firstUncommitted == null || lastUncommitted == null) {
                Logging.debug((String)"[TTM] Tried to commit time, but fields were null (firstUncommitted={0},lastUncommitted={1})", (Object[])new Object[]{firstUncommitted, lastUncommitted});
            } else {
                if (Logging.isDebugEnabled()) {
                    Logging.debug((String)MessageFormat.format("[TTM] Committing uncommitted time of {0,number,#} seconds ({1,number,#} \u2013 {2,number,#}) with {3,number,#} seconds tolerance", lastUncommitted - firstUncommitted, firstUncommitted, lastUncommitted, RovasProperties.INACTIVITY_TOLERANCE.get()));
                }
                this.committedSeconds = TimeConverterUtil.clampToSeconds(this.committedSeconds + Math.max(0L, lastUncommitted - firstUncommitted) + Math.min(Math.max(0L, currentInstant.getEpochSecond() - lastUncommitted), (long)Math.max(0, RovasProperties.INACTIVITY_TOLERANCE.get())));
            }
        });
        Logging.debug((String)"[TTM] Reset to `{0,number,#}` ({1,number,#} committed)", (Object[])new Object[]{newValue, this.committedSeconds});
        this.firstUncommittedChangeTimestamp = newValue;
        this.lastUncommittedChangeTimestamp = newValue;
        this.fireTimeTrackingUpdateListeners();
        return this.committedSeconds;
    }
}

