/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.util;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.DefaultFormatter;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public final class GuiComponentFactory {
    private GuiComponentFactory() {
    }

    public static JMultilineLabel createHyperlinkedMultilineLabel(String text) {
        JMultilineLabel label = new JMultilineLabel(text);
        label.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.displayUrl((String)e.getURL().toExternalForm());
            }
        });
        return label;
    }

    public static JPanel createWrapperPanel(LayoutManager layoutManager, Component ... components) {
        JPanel panel = new JPanel(layoutManager);
        panel.setOpaque(false);
        Arrays.stream(components).forEach(panel::add);
        return panel;
    }

    public static JPanel createWrapperPanel(Component c) {
        return GuiComponentFactory.createWrapperPanel(new GridLayout(1, 1), c);
    }

    public static JLabel createLabel(String text, boolean bold) {
        return GuiComponentFactory.createLabel(text, bold, Optional.empty());
    }

    public static JLabel createLabel(String text, boolean bold, int horizontalAlignment) {
        return GuiComponentFactory.createLabel(text, bold, Optional.of(horizontalAlignment));
    }

    private static JLabel createLabel(String text, boolean bold, Optional<Integer> alignment) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(bold ? 1 : 0));
        alignment.ifPresent(label::setHorizontalAlignment);
        return label;
    }

    public static JSpinner createSpinner(SpinnerModel model, int columns, boolean hideArrowButtons) {
        return GuiComponentFactory.createSpinner(model, columns, hideArrowButtons, "#");
    }

    public static JSpinner createSpinner(SpinnerModel model, int columns, boolean hideArrowButtons, String decimalFormatPattern) {
        JSpinner spinner = new JSpinner(model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, decimalFormatPattern);
        Utils.instanceOfAndCast((Object)editor.getTextField().getFormatter(), DefaultFormatter.class).ifPresent(formatter -> formatter.setCommitsOnValidEdit(true));
        editor.getTextField().setColumns(columns);
        spinner.setEditor(editor);
        if (hideArrowButtons) {
            spinner.setUI(new BasicSpinnerUI(){

                @Override
                protected Component createNextButton() {
                    return null;
                }

                @Override
                protected Component createPreviousButton() {
                    return null;
                }
            });
        }
        return spinner;
    }
}

