/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.util;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;

public class NullableProperty<T> {
    private final AbstractToStringProperty<T> delegate;
    private final Predicate<T> acceptableValues;
    private final T pseudoNull;

    public NullableProperty(@NotNull AbstractToStringProperty<T> delegate, @NotNull Predicate<T> acceptableValues) {
        this(delegate, acceptableValues, null);
    }

    public NullableProperty(@NotNull AbstractToStringProperty<T> delegate, @NotNull Predicate<T> acceptableValues, T pseudoNull) {
        this.delegate = delegate;
        this.acceptableValues = it -> it != null && acceptableValues.test(it);
        this.pseudoNull = pseudoNull;
    }

    @Nullable
    public T get() {
        return Optional.ofNullable(this.delegate.get()).filter(this.acceptableValues).orElse(null);
    }

    public boolean put(@Nullable T value) {
        return this.delegate.put(Optional.ofNullable(value).filter(this.acceptableValues).orElse(this.pseudoNull));
    }
}

