/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.util;

import com.drew.lang.annotations.NotNull;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends FilterInputStream {
    private final OutputStream redirectTo;

    public TeeInputStream(@NotNull InputStream in, @NotNull OutputStream redirectTo) {
        super(in);
        this.redirectTo = redirectTo;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        this.redirectTo.write(result);
        return result;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            this.redirectTo.write(b, off, Math.min(len, result));
        }
        return result;
    }
}

