/*
 * Decompiled with CFR 0.152.
 */
package app.rovas.josm.util;

import app.rovas.josm.model.RovasProperties;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class UrlProvider {
    private static final String BASE_URL_DEVELOPMENT = "https://dev.merit.world";
    private static final String BASE_URL_PRODUCTION = "https://rovas.app";
    private static final UrlProvider INSTANCE = new UrlProvider();
    private static final String PATH_API_CHECK_OR_ADD_SHAREHOLDER = "/rovas/rules/rules_proxy_check_or_add_shareholder";

    public static UrlProvider getInstance() {
        return INSTANCE;
    }

    public static String toHtmlHyperlink(@Nullable URL url, @NotNull String label) {
        return url == null ? label : String.format("<a href=\"%s\">%s</a>", url, label);
    }

    protected UrlProvider() {
    }

    public static URL uncheckedURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new JosmRuntimeException("The rovas plugin builds broken URLs: " + urlString, (Throwable)e);
        }
    }

    protected String getBaseUrl() {
        return RovasProperties.DEVELOPER.get() != false ? BASE_URL_DEVELOPMENT : BASE_URL_PRODUCTION;
    }

    @NotNull
    public URL node(int id) {
        return UrlProvider.uncheckedURL(this.getBaseUrl() + String.format("/node/%d", id));
    }

    @NotNull
    public URL rules() {
        return UrlProvider.uncheckedURL(this.getBaseUrl() + "/rules");
    }

    @NotNull
    public URL userProfile() {
        return UrlProvider.uncheckedURL(this.getBaseUrl() + "/user");
    }

    @NotNull
    public URL rulesCreateAUR() {
        return UrlProvider.uncheckedURL(this.getBaseUrl() + "/rovas/rules/rules_proxy_create_aur");
    }

    @NotNull
    public URL rulesCheckOrAddShareholder() {
        return UrlProvider.uncheckedURL(this.getBaseUrl() + PATH_API_CHECK_OR_ADD_SHAREHOLDER);
    }

    @NotNull
    public URL rulesCreateWorkReport() {
        return UrlProvider.uncheckedURL(this.getBaseUrl() + "/rovas/rules/rules_proxy_create_work_report");
    }
}

